// config: norepeat

#include "GetObjects.js"
#include "GetRect.js"
#include "GetBoxExtrusion.js"
#include "WaitForDialogDone.js"

function DoArray()
{
	// First get the objects to array.

	var ui = moi.ui;
	var objectpicker = ui.createObjectPicker();
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;
	var factory = moi.command.createFactory( 'arraygrid' );

	// Now get the number of copies to make.

	ui.beginUIUpdate();
	ui.hideUI( 'SelectPrompt' );
	ui.showUI( 'NumberPrompt' );
	ui.showUI( 'NumberOptions' );
	ui.endUIUpdate();
	
	ui.bindUIToInput( 'NumX', 'value', factory.getInput(6) );
	ui.bindUIToInput( 'NumY', 'value', factory.getInput(7) );
	ui.bindUIToInput( 'NumZ', 'value', factory.getInput(8) );

	if ( !WaitForDialogDone() )
		return;
		
	var NumX = 1;
	var NumY = 1;
	var NumZ = 1;
	
	try
	{
		NumX = factory.getInput(6).getValue();
		NumY = factory.getInput(7).getValue();
		NumZ = factory.getInput(8).getValue();
	}
	catch(e)
	{
	}
	
	if ( NumX <= 1 && NumY <= 1 && NumZ <= 1 )
		return;
		
	var HaveZCopies = (NumZ > 1);
		
	
	// Now get the spacing, first for XY. It can either be entered directly or a rectangle
	// can be drawn.
	
	ui.beginUIUpdate();
	ui.hideUI( 'NumberPrompt' );
	ui.hideUI( 'NumberOptions' );
	ui.showUI( 'SpacingOrCornerPrompt' );
	ui.showUI( 'XYSpacingOptions' );
	
	if ( NumX == 1 && NumY != 1 )
		ui.hideUI( 'xspacingtr' );
		
	if ( NumY == 1 && NumX != 1 )
		ui.hideUI( 'yspacingtr' );
		
	ui.endUIUpdate();

	var pointpicker = moi.ui.createPointPicker();

	// Keep track of whether the spacing is being drawn with the mouse or not. If a width
	// or height is entered instead of picking a point, then we will enter non-mouse mode and
	// just wait for the numbers to be entered directly. This is because array is different
	// than a pure rectangle draw, in that it can use width/height/extrusion values by
	// themselves without actually needing a corner point.
	
	var DrawingRect = false;
	
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() || pointpicker.event == 'done' )
			return;
			
		if ( pointpicker.event == 'finished' )
		{
			// A point was picked, so a rect is being drawn.
			DrawingRect = true;
			break;
		}
		else if ( pointpicker.event == 'width' )
		{
			// Width was entered instead of a point pick, so we're not drawing a rect.
			factory.setInput( 2, ui.commandUI.width.value );
			DrawingRect = false;
			break;
		}
		else if ( pointpicker.event == 'height' )
		{
			// Height was entered instead of a point pick, so we're not drawing a rect.
			factory.setInput( 3, ui.commandUI.height.value );
			DrawingRect = false;
			break;
		}
	}
	
	if ( DrawingRect )
	{
		// We're drawing the spacing with the mouse, set up that prompt and get the
		// other corner.
	
		ui.beginUIUpdate();
		ui.hideUI( 'SpacingOrCornerPrompt' );
		ui.showUI( 'LastCornerPrompt' );
		ui.endUIUpdate();
	
		if ( !GetRectSecondPoint( factory, pointpicker ) )
			return;
	}
	else
	{
		// We're not drawing with the mouse, set up the prompt and wait for the width and
		// height to be filled in.
		
		// Get rid of any pointpicker decorations.
		ui.redrawViewports();

		ui.beginUIUpdate();
		ui.hideUI( 'SpacingOrCornerPrompt' );
		ui.showUI( 'XYSpacingPrompt' );
		ui.endUIUpdate();

		// If not using a direction, set a default distance of 1.0 in there.
		if ( NumX == 1 )
			factory.setInput( 2, 1.0 );
			
		if ( NumY == 1 )
			factory.setInput( 3, 1.0 );
		
		
		var dialog = ui.commandDialog;
		
		while ( 1 )
		{
			var HaveWidth = false, HaveHeight = false;
			
			try
			{
				HaveWidth = (factory.getInput(2).getValue() != 0.0);
				HaveHeight = (factory.getInput(3).getValue() != 0.0);
			}
			catch(e)
			{
			}
				
			if ( HaveWidth && HaveHeight )
				break;
	
			if ( !dialog.waitForEvent() )
				return;
				
			if ( dialog.event == 'done' )
				break;
				
			if ( dialog.event == 'width' )
				factory.setInput( 2, ui.commandUI.width.value );
			else if ( dialog.event == 'height' )
				factory.setInput( 3, ui.commandUI.height.value );
		}
	}
		
	if ( HaveZCopies )
	{
		// If there are z copies then get the z spacing as a last step.

		ui.beginUIUpdate();
		ui.hideUI( 'LastCornerPrompt' );
		ui.hideUI( 'XYSpacingPrompt' );		
		ui.hideUI( 'XYSpacingOptions' );
		ui.showUI( 'ZSpacingPrompt' );
		ui.showUI( 'ZSpacingOptions' );
		ui.endUIUpdate();
		
		if ( DrawingRect )
		{
			// If we're drawing with the mouse, draw a box.
			if ( !GetBoxExtrusion( factory, 4, factory.rectFrame ) )
				return;
		}
		else
		{
			// Otherwise, wait for the z value to be entered.
		
			var dialog = ui.commandDialog;
			
			while ( 1 )
			{
				if ( !dialog.waitForEvent() || dialog.event == 'done' )
					return;
					
				if ( dialog.event == 'extrusion' )
				{
					factory.setInput( 4, ui.commandUI.extrusion.value );
					break;
				}
			}
		}
	}
	
	factory.setInput( 9, objects );
	
	factory.update();
	factory.commit();
}

DoArray();
